/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq.sleuth;

import brave.Span;
import brave.Tags;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.sleuth.RocketmqSleuthConsumeMessageHook;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.sleuth.RocketmqSleuthContext;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class RocketmqSleuthPlugin {
    @Resource
    private Tracer tracer;
    @Resource
    private Tracing tracing;
    @Resource
    private RocketmqSleuthConsumeMessageHook rocketmqSleuthConsumeMessageHook;
    private TraceContext.Injector<Message> injector;
    private TraceContext.Extractor<Message> extractor;

    @PostConstruct
    public void init() {
        this.injector = this.tracing.propagation().injector(Message::putUserProperty);
        this.extractor = this.tracing.propagation().extractor(Message::getUserProperty);
    }

    @Around(value="execution(* org.apache.rocketmq.client.producer.MQProducer.send*(org.apache.rocketmq.common.message.Message,..)) && args(message,..)", argNames="point,message")
    public Object send(ProceedingJoinPoint point, Message message) throws Throwable {
        return this.rocketMqSendJoinPoint(point, message, "send");
    }

    @Around(value="execution(* org.apache.rocketmq.client.producer.MQProducer.request(org.apache.rocketmq.common.message.Message,..)) && args(message,..)", argNames="point,message")
    public Object sendMessages(ProceedingJoinPoint point, Message message) throws Throwable {
        return this.rocketMqSendJoinPoint(point, message, "request");
    }

    public Object rocketMqSendJoinPoint(ProceedingJoinPoint point, Message message, String type) throws Throwable {
        Span curSpan = this.tracer.currentSpan();
        if (curSpan == null || curSpan.isNoop()) {
            return point.proceed();
        }
        Span span = this.tracer.nextSpan().name("rocketmq-send").kind(Span.Kind.PRODUCER).remoteServiceName("rocketmq").start();
        try {
            Object object;
            block12: {
                Tracer.SpanInScope scope = this.tracer.withSpanInScope(span);
                try {
                    this.injector.inject(span.context(), (Object)message);
                    span.tag("lc", "rocketmqProducer");
                    span.tag("rocketmq.topic", message.getTopic());
                    span.tag("rocketmq.tags", StringUtils.defaultString((String)message.getTags()));
                    span.tag("rocketmq.type", type);
                    span.tag("producer.thread", Thread.currentThread().getName());
                    object = point.proceed();
                    if (scope == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception error) {
                        Tags.ERROR.tag((Object)error, span);
                        throw error;
                    }
                }
                scope.close();
            }
            return object;
        }
        finally {
            span.finish();
        }
    }

    @Around(value="execution(* org.apache.rocketmq.spring.core.RocketMQListener.onMessage(..))")
    public Object rocketMqListener(ProceedingJoinPoint point) throws Throwable {
        return this.rocketMqListenerJoinPoint(point, "rocketMQListener");
    }

    @Around(value="execution(* org.apache.rocketmq.spring.core.RocketMQReplyListener.onMessage(..))")
    public Object rocketMqReplyListener(ProceedingJoinPoint point) throws Throwable {
        return this.rocketMqListenerJoinPoint(point, "rocketMQReplyListener");
    }

    public Object rocketMqListenerJoinPoint(ProceedingJoinPoint point, String listenerName) throws Throwable {
        RocketmqSleuthContext context = this.rocketmqSleuthConsumeMessageHook.getRocketmqSleuthContext();
        if (Objects.isNull(context)) {
            return point.proceed();
        }
        MessageExt message = context.poll();
        if (Objects.isNull(message)) {
            return point.proceed();
        }
        Object target = point.getTarget();
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)message);
        Span span = this.tracer.nextSpan(extracted).name("rocketmq-consume").kind(Span.Kind.SERVER).remoteServiceName("rocketmq").start();
        try {
            Object object;
            block13: {
                Tracer.SpanInScope scope = this.tracer.withSpanInScope(span);
                try {
                    span.tag("lc", listenerName);
                    span.tag("rocketmq.topic", message.getTopic());
                    span.tag("rocketmq.tags", StringUtils.defaultString((String)message.getTags()));
                    span.tag("rocketmq.type", "consume");
                    span.tag("consumer.class", target.getClass().getSimpleName());
                    span.tag("consumer.thread", Thread.currentThread().getName());
                    object = point.proceed();
                    if (scope == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception error) {
                        Tags.ERROR.tag((Object)error, span);
                        throw error;
                    }
                }
                scope.close();
            }
            return object;
        }
        finally {
            span.finish();
        }
    }

    @Around(value="execution(* org.apache.rocketmq.client.consumer.listener.MessageListener*.consumeMessage(java.util.List<org.apache.rocketmq.common.message.MessageExt>,..)) && args(msgs,..)", argNames="joinPoint,msgs")
    public Object rocketMqConsumeJoinPoint(ProceedingJoinPoint joinPoint, List<MessageExt> msgs) throws Throwable {
        if (msgs.isEmpty()) {
            return joinPoint.proceed();
        }
        MessageExt msg = msgs.get(0);
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)msg);
        Span span = this.tracer.nextSpan(extracted).name("rocketmq-consume").kind(Span.Kind.SERVER).remoteServiceName("rocketmq").start();
        try {
            Object object;
            block12: {
                Tracer.SpanInScope scope = this.tracer.withSpanInScope(span);
                try {
                    span.tag("lc", "rocketmqConsumer");
                    span.tag("rocketmq.topic", msg.getTopic());
                    span.tag("rocketmq.tags", StringUtils.defaultString((String)msg.getTags()));
                    span.tag("rocketmq.type", "consume");
                    span.tag("consumer.thread", Thread.currentThread().getName());
                    object = joinPoint.proceed();
                    if (scope == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception error) {
                        Tags.ERROR.tag((Object)error, span);
                        throw error;
                    }
                }
                scope.close();
            }
            return object;
        }
        finally {
            span.finish();
        }
    }
}

