/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.velocity;

import cn.com.duibaboot.ext.autoconfigure.velocity.EmbeddedVelocityViewResolver;
import cn.com.duibaboot.ext.autoconfigure.velocity.VelocityProperties;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ui.velocity.VelocityEngineFactory;
import org.springframework.ui.velocity.VelocityEngineFactoryBean;
import org.springframework.web.servlet.resource.ResourceUrlEncodingFilter;
import org.springframework.web.servlet.view.velocity.VelocityConfig;
import org.springframework.web.servlet.view.velocity.VelocityConfigurer;

@Configuration
@ConditionalOnClass(value={VelocityEngine.class, VelocityEngineFactory.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={VelocityProperties.class})
@Deprecated
public class VelocityAutoConfiguration {
    private static final Log logger = LogFactory.getLog(VelocityAutoConfiguration.class);
    private final ApplicationContext applicationContext;
    private final VelocityProperties properties;

    public VelocityAutoConfiguration(ApplicationContext applicationContext, VelocityProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @PostConstruct
    public void checkTemplateLocationExists() {
        TemplateLocation location;
        if (this.properties.isCheckTemplateLocation() && !(location = new TemplateLocation(this.properties.getResourceLoaderPath())).exists((ResourcePatternResolver)this.applicationContext)) {
            logger.warn((Object)("Cannot find template location: " + location + " (please add some templates, check your Velocity configuration, or set spring.velocity.checkTemplateLocation=false)"));
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class})
    @ConditionalOnWebApplication
    @Deprecated
    public static class VelocityWebConfiguration
    extends VelocityConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={VelocityConfig.class})
        public VelocityConfigurer velocityConfigurer() {
            VelocityConfigurer configurer = new VelocityConfigurer();
            this.applyProperties((VelocityEngineFactory)configurer);
            return configurer;
        }

        @Bean
        public VelocityEngine velocityEngine(VelocityConfigurer configurer) throws VelocityException, IOException {
            return configurer.getVelocityEngine();
        }

        @Bean
        @ConditionalOnMissingBean(name={"velocityViewResolver"})
        @ConditionalOnProperty(name={"spring.velocity.enabled"}, matchIfMissing=true)
        public EmbeddedVelocityViewResolver velocityViewResolver() {
            EmbeddedVelocityViewResolver resolver = new EmbeddedVelocityViewResolver();
            this.properties.applyToViewResolver((Object)resolver);
            return resolver;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledResourceChain
        public ResourceUrlEncodingFilter resourceUrlEncodingFilter() {
            return new ResourceUrlEncodingFilter();
        }
    }

    @Configuration
    @ConditionalOnNotWebApplication
    @Deprecated
    public static class VelocityNonWebConfiguration
    extends VelocityConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public VelocityEngineFactoryBean velocityConfiguration() {
            VelocityEngineFactoryBean velocityEngineFactoryBean = new VelocityEngineFactoryBean();
            this.applyProperties((VelocityEngineFactory)velocityEngineFactoryBean);
            return velocityEngineFactoryBean;
        }
    }

    @Deprecated
    protected static class VelocityConfiguration {
        @Autowired
        protected VelocityProperties properties;

        protected VelocityConfiguration() {
        }

        protected void applyProperties(VelocityEngineFactory factory) {
            factory.setResourceLoaderPath(this.properties.getResourceLoaderPath());
            factory.setPreferFileSystemAccess(this.properties.isPreferFileSystemAccess());
            Properties velocityProperties = new Properties();
            velocityProperties.setProperty("input.encoding", this.properties.getCharsetName());
            velocityProperties.putAll(this.properties.getProperties());
            factory.setVelocityProperties(velocityProperties);
        }
    }
}

