/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.actuator;

import javax.annotation.Resource;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.stream.binder.rocketmq.metrics.Instrumentation;
import org.springframework.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;

public class RocketMQBinderHealthIndicator
extends AbstractHealthIndicator {
    @Resource
    private InstrumentationManager instrumentationManager;

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.instrumentationManager.getHealthInstrumentations().stream().allMatch(Instrumentation::isUp)) {
            builder.up();
            return;
        }
        if (this.instrumentationManager.getHealthInstrumentations().stream().allMatch(Instrumentation::isOutOfService)) {
            builder.outOfService();
            return;
        }
        builder.down();
        this.instrumentationManager.getHealthInstrumentations().stream().filter(instrumentation -> !instrumentation.isStarted()).forEach(instrumentation1 -> builder.withException((Throwable)instrumentation1.getStartException()));
    }
}

