/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.integration;

import cn.com.duibaboot.ext.stream.binder.BinderMessageProducer;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binder.rocketmq.consuming.RocketMQListenerBindingContainer;
import org.springframework.cloud.stream.binder.rocketmq.metrics.Instrumentation;
import org.springframework.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;

public class RocketMQInboundChannelAdapter
extends MessageProducerSupport
implements BinderMessageProducer {
    private static final Logger log = LoggerFactory.getLogger(RocketMQInboundChannelAdapter.class);
    private RocketMQListenerBindingContainer rocketMQListenerContainer;
    private final InstrumentationManager instrumentationManager;

    public RocketMQInboundChannelAdapter(RocketMQListenerBindingContainer rocketMQListenerContainer, InstrumentationManager instrumentationManager) {
        this.rocketMQListenerContainer = rocketMQListenerContainer;
        this.instrumentationManager = instrumentationManager;
    }

    public void init() {
        super.onInit();
        BindingRocketMQListener listener = new BindingRocketMQListener();
        this.rocketMQListenerContainer.setRocketMQListener(listener);
        try {
            this.rocketMQListenerContainer.afterPropertiesSet();
        }
        catch (Exception e) {
            log.error("rocketMQListenerContainer init error: " + e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("rocketMQListenerContainer init error: " + e.getMessage(), e);
        }
        this.instrumentationManager.addHealthInstrumentation(new Instrumentation(this.rocketMQListenerContainer.getTopic() + this.rocketMQListenerContainer.getConsumerGroup()));
        super.start();
    }

    public void stopListener() {
        super.stop();
    }

    protected void doStart() {
        try {
            this.rocketMQListenerContainer.start();
            this.instrumentationManager.getHealthInstrumentation(this.rocketMQListenerContainer.getTopic() + this.rocketMQListenerContainer.getConsumerGroup()).markStartedSuccessfully();
        }
        catch (Exception e) {
            this.instrumentationManager.getHealthInstrumentation(this.rocketMQListenerContainer.getTopic() + this.rocketMQListenerContainer.getConsumerGroup()).markStartFailed(e);
            log.error("RocketMQTemplate startup failed, Caused by " + e.getMessage());
            throw new MessagingException(MessageBuilder.withPayload((Object)("RocketMQTemplate startup failed, Caused by " + e.getMessage())).build(), (Throwable)e);
        }
    }

    protected void doStop() {
        this.rocketMQListenerContainer.stop();
    }

    protected class BindingRocketMQListener
    implements RocketMQListener<Message>,
    RetryListener {
        protected BindingRocketMQListener() {
        }

        @Override
        public void onMessage(Message message) {
            RocketMQInboundChannelAdapter.this.sendMessage(message);
        }

        public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
            return true;
        }

        public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        }

        public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        }
    }
}

