package cn.com.duibaboot.ext.stream.channel;

import lombok.Data;

import java.util.Objects;

@Data
public class ChannelKey {

    private String bindingName;

    private ChannelType channelType;

    public ChannelKey(){}

    public ChannelKey(String bindingName, ChannelType channelType) {
        this.bindingName = bindingName;
        this.channelType = channelType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ChannelKey)) return false;
        ChannelKey that = (ChannelKey) o;
        return Objects.equals(bindingName, that.bindingName) &&
                channelType == that.channelType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bindingName, channelType);
    }

    @Override
    public String toString() {
        return "Channel{" +
                "bindingName='" + bindingName + '\'' +
                ", channelType=" + channelType +
                '}';
    }
}
