package cn.com.duibaboot.ext.stream.channel;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.util.Assert;

import java.util.Objects;

public class ChannelFactoryBean implements FactoryBean<AbstractMessageChannel> {

    private static final String PRODUCER_BEAN_NAME_SUFFIX = "MessageChannel";

    private static final String CONSUMER_BEAN_NAME_SUFFIX = "SubscribableChannel";

    private ChannelKey channelKey;

    private ChannelInterceptorBox channelInterceptorBox;

    public static String getBeanNameByBindingName(ChannelKey channelKey){
        Assert.isTrue(StringUtils.isNotBlank(channelKey.getBindingName()),"绑定名称缺失");
        Assert.isTrue(Objects.nonNull(channelKey.getChannelType()),"通道类型缺失");
        StringBuilder builder = new StringBuilder(channelKey.getBindingName());
        if(channelKey.getChannelType()==ChannelType.OUTPUT){
            builder.append(PRODUCER_BEAN_NAME_SUFFIX);
        }else if(channelKey.getChannelType()==ChannelType.INPUT){
            builder.append(CONSUMER_BEAN_NAME_SUFFIX);
        }
        return builder.toString();
    }

    @Override
    public AbstractMessageChannel getObject() {

        String beanName = getBeanNameByBindingName(channelKey);
        AbstractMessageChannel channel = null;
        if(channelKey.getChannelType()==ChannelType.INPUT){
            channel = new ExecutorSubscribableChannel();
        }
        if(channelKey.getChannelType()==ChannelType.OUTPUT){
            channel = new ProducerMessageChannel();
        }
        if(Objects.isNull(channel)){
            throw new IllegalArgumentException("未设置通道类型");
        }
        channel.setBeanName(beanName);
        channel.setInterceptors(channelInterceptorBox.getChannelInterceptors());//添加通道拦截器

        return channel;
    }

    @Override
    public Class<?> getObjectType() {
        return AbstractMessageChannel.class;
    }

    public ChannelInterceptorBox getChannelInterceptorBox() {
        return channelInterceptorBox;
    }

    public void setChannelInterceptorBox(ChannelInterceptorBox channelInterceptorBox) {
        this.channelInterceptorBox = channelInterceptorBox;
    }

    public ChannelKey getChannelKey() {
        return channelKey;
    }

    public void setChannelKey(ChannelKey channelKey) {
        this.channelKey = channelKey;
    }
}
