package cn.com.duibaboot.ext.stream.config;

import lombok.Data;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

/**
 * @author liuyao
 */
@Data
public class BindingProperties {

    public static final MimeType DEFAULT_CONTENT_TYPE = MimeTypeUtils.APPLICATION_JSON;
    /**
     * The name of the binder to use for this binding in the event multiple binders
     * available (e.g., 'rabbit').
     */
    private String binder;

    /**
     * Additional consumer specific properties (see {@link ConsumerProperties}).
     */
    private ConsumerProperties consumer = new ConsumerProperties();

    /**
     * Additional producer specific properties (see {@link ProducerProperties}).
     */
    private ProducerProperties producer = new ProducerProperties();

    private String bindingName;

}
