package cn.com.duibaboot.ext.stream.support;

import cn.com.duibaboot.ext.stream.binding.Binding;
import cn.com.duibaboot.ext.stream.binding.BindingService;
import cn.com.duibaboot.ext.stream.channel.ChannelKey;
import cn.com.duibaboot.ext.stream.channel.ChannelType;
import cn.com.duibaboot.ext.stream.config.BindingProperties;
import cn.com.duibaboot.ext.stream.config.BindingServiceProperties;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Objects;

@Slf4j
public class StreamTemplate {

    @Resource
    private CompositeMessageConverter compositeMessageConverter;
    @Resource
    private BindingService bindingService;
    @Resource
    private BindingServiceProperties bindingServiceProperties;

    public void send(String bindingName,Object event){
        Map<String,Object> headers =  Maps.newLinkedHashMap();
        if(event instanceof StreamMesseage){
            String topic = ((StreamMesseage)event).topic();
            Assert.isTrue(!StringUtils.isEmpty(topic),"StreamMesseage 的 topic不能为空");
            headers.put(StreamMessageHeaders.TOPIC,topic);
        }else{
            BindingProperties bindingProperties = bindingServiceProperties.getBindings().get(bindingName);
            Assert.notNull(bindingProperties,"未配置["+bindingName+"]对应的通道");
            String defaultTopic = bindingProperties.getProducer().getDefaultTopic();
            Assert.isTrue(!StringUtils.isEmpty(defaultTopic),"未能解析出消息中的topic,请确保事件对象实现StreamMesseage接口或者给binding设置默认topic");
            headers.put(StreamMessageHeaders.TOPIC,defaultTopic);
        }

        Message message = compositeMessageConverter.toMessage(event,new MessageHeaders(headers));
        if(Objects.isNull(message)){
            log.warn("Stream事件["+event.getClass().getName()+"]未能正常发布,请提供对应的MessageConverter转化器");
            return;
        }
        ChannelKey key = new ChannelKey(bindingName, ChannelType.OUTPUT);
        Binding binding = bindingService.getBinding(key);

        AbstractMessageChannel producerMessageChannel = binding.getMessageChannel();
        producerMessageChannel.send(message);
    }

}
