# 延时引擎文档

## 1.介绍
延时任务在日常业务中的使用是比较常见的。例如对于电商而言常见的场景：

当订单一直处于未支付的状态，需要在一定时间后关闭订单，退还库存。
订单完成15天后未评价自动评价等等...

新的延时任务对比老的来说，更加稳定，数据不易丢失。

接入方式
```
compile "cn.com.duiba.cloud:delay-client:0.0.8"
```

## 2.配置

**延时任务topic**:

配置格式
```
引入公共配置 delay-engine.delay-engine-client
duiba.cloud.delay-engine.mq.topic = delay-engine-topic-[环境标识]
duiba.cloud.delay-engine.mq.consumer-group = delay-message-group
duiba.cloud.delay-engine.mq.nameserver = [ip分号分隔]
```

## 3.使用

```
    @Resource
    private DelayMessageClient delayMessageClient;
    
    public void sendDelayMessage(){
       String bizNo;   // 业务编号
       String bizType; // 业务类型 
       Integer fireTime;  // 点火时间，需要执行任务的时间
       TimeUnit timeUnit; // 时间单位
       JsonResult<String> result = delayMessageClient.sendDelayMessage(bizType,bizId,fireTime,timeUnit);
    }
```
## 4.回调任务实现

```
// 需要添加到spring容器当中
    @Component
    public class Test extends BaseDelayMessageCallBack {
    
        @Override
        public String settingBizType() {
            return "bizType";
        }
    
        @Override
        public void consumerMessage(String bizNo) {
            System.out.println("执行延时任务");
        }
    }
```