package cn.com.duiba.cloud.delay.client;


import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * 延迟消息客户端
 *
 * @author zouweixiang
 * @date 2021/11/16
 */
public interface DelayMessageClient {

    /**
     * 延迟发送消息
     *
     * @param bizType  业务类型
     * @param bizNo    业务标识
     * @param fireTime 点火时间，需要回调发送消息的时间
     * @param timeUnit 时间单位
     */
    void sendDelayMessage(String bizType, String bizNo, Integer fireTime, TimeUnit timeUnit);


    /**
     * 发送延迟消息v2
     * 可以提前预知点火时间，可使用此接口
     *
     * @param bizType  业务类型
     * @param bizNo    业务标识
     * @param fireTime 点火时间，需要回调发送消息的时间
     */
    void sendDelayMessageV2(String bizType, String bizNo, Date fireTime);


    /**
     * 延迟发送消息指定应用
     *
     * @param appId    应用程序id
     * @param bizType  业务类型
     * @param bizNo    业务标识
     * @param fireTime 点火时间，需要回调发送消息的时间
     * @param timeUnit 时间单位
     */
    void sendDelayMessageByApp(String appId, String bizType, String bizNo, Integer fireTime, TimeUnit timeUnit);


    /**
     * 延迟发送消息指定应用
     * 可以提前预知点火时间，可使用此接口
     *
     * @param appId    应用程序id
     * @param bizType  业务类型
     * @param bizNo    业务标识
     * @param fireTime 点火时间，需要回调发送消息的时间
     */
    void sendDelayMessageByAppV2(String appId, String bizType, String bizNo, Date fireTime);
}
