package cn.com.duiba.cloud.delay.client.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 延迟消息参数
 *
 * @author zouweixiang
 * @date 2021/11/11
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DelayMessageParam implements Serializable {

    private static final long serialVersionUID = 5264677785587407895L;

    /**
     * 业务编号
     */
    @NotBlank(message = "业务编号为空")
    private String bizNo;

    /**
     * 业务类型
     */
    @NotBlank(message = "业务类型为空")
    private String bizType;

    /**
     * 应用程序id
     */
    @NotBlank(message = "应用程序id为空")
    private String appId;

    /**
     * 点火时间
     */
    @NotNull(message = "点火时间为空")
    private Date fireTime;

}
