package cn.com.duiba.cloud.duiba.activity.service.api.dto.activity;

import lombok.Data;

import java.io.Serializable;

/**
 * 发奖规则返回数据
 *
 * @author jiaxz
 */
@Data
public class StrategyResult implements Serializable {

    private static final long serialVersionUID = -4915972243693241751L;

    /**
     * 奖项ID
     */
    Long id;

    /**
     * 发奖规则
     */
    String ruleName;

    /**
     * 奖项名称
     */
    String prizeName;
    
    
    /**
     * 奖项图片
     */
    String icon;
    

    /**
     * 奖品的类型
     */
    Integer prizeType;
    

    /**
     * 用户奖品记录ID
     */
    Long userRecordId;

    /**
     * 扩展数据
     */
    String ext;

    /**
     * 订单号
     */
    String orderNum;

    /**
     * skuid
     */
    Long skuId;

    /**
     *
     */
    String itemName;

    /**
     * 商品类型(1:实物,2:优惠券:3:充值,4:权益)
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum
     */
    Integer itemType;

    /**
     * 商品来源：1，自有商品；2，供应商商品
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.GoodsSourceEnum
     */
    Integer itemSource;

    /**
     * 是否已领取：true，已领取；false，待领取
     */
    boolean hasReceive;
}
