package cn.com.duiba.cloud.duiba.activity.service.api.enums;

/**
 * @author zhengjianhao
 * @date 2022/4/1
 * @description 来源渠道枚举
 */
public enum SourceTerminalTypeEnum {
	APP(1,  "app", "app"),
	WECHAT(2, "wechat_h5",  "微信H5"),
	WECHAT_MINI_PROGRAM(3, "wechat_mini_program",  "微信小程序"),
	;

	private int id;
	private String code;
	private String desc;

	SourceTerminalTypeEnum(int id, String code, String desc) {
		this.id = id;
		this.code = code;
		this.desc = desc;
	}

	public int getId() {
		return id;
	}

	public String getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}

	public static String getCodeById(Integer typeId){
		if(null == typeId){
			return null;
		}
		for(SourceTerminalTypeEnum sourceTerminalType: SourceTerminalTypeEnum.values()){
			if(sourceTerminalType.getId() == typeId){
				return sourceTerminalType.getCode();
			}
		}
		return null;
	}
}
