package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.answer;

import cn.com.duiba.cloud.duiba.activity.service.api.enums.CommonStatusEnum;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.answer.AnswerJudgeTypeEnum;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.answer.QuestionTimeLimitTypeEnum;
import cn.com.duiba.cloud.duiba.activity.service.api.utils.EnumValid;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 答题活动配置
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/4/14
 */
@Data
public class AnswerActivityConfigVO implements Serializable {

    private static final long serialVersionUID = -7228853508745171355L;

    /**
     * 答题时间限制
     * 0-不限制 1-总时间限制 2-单个题目限制
     */
    @NotNull(message = "答题时间限制类型不能为空")
    @EnumValid(target = QuestionTimeLimitTypeEnum.class, message = "答题时间限制类型不合法")
    private Integer timeLimitType;

    /**
     * 限制时间 单位：秒
     */
    @Max(value = 9999, message = "限制时间不能超过9999秒")
    @Min(value = 1, message = "限制时间不能低于1秒")
    private Integer timeLimit;

    /**
     * 判断对错时机
     * 0-选择时判断 1-提交时判断 2-答题结束时判断
     */
    @NotNull(message = "判断对错时机类型不能为空")
    @EnumValid(target = AnswerJudgeTypeEnum.class, message = "判断对错时机类型不合法")
    private Integer judgeType;

    /**
     * 是否展示正确答案
     * 0-不展示 1-展示
     */
    @EnumValid(target = CommonStatusEnum.class, message = "是否展示正确答案类型不合法", field = "status")
    private Integer showRightAnswer;

    /**
     * 每次参与活动的题目数量，不超过总题目数量
     */
    @NotNull(message = "参与活动题目数量不能为空")
    @Max(value = 50, message = "参与活动的题目数量不能超过50")
    @Min(value = 1, message = "参与活动的题目数量不能小于1")
    private Integer questionNum;

    /**
     * 题目配置，最多50条
     */
    @NotEmpty(message = "题目配置不能为空")
    @Size(min = 1, max = 50, message = "可配置的题目数量范围在1～50之间")
    @Valid
    private List<QuestionConfigVO> questionList;

}

