package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.signup;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 报名配置
 * @author sunyan
 */
@Data
public class SignupConfigVO implements Serializable {

    private static final long serialVersionUID = -3593333477943306637L;
    /**
     * 表单类型
     * 1-报名；2-问卷调研
     */
    @NotNull(message="表单类型不能为空")
    private Integer formType;

    /**
     * 报名截止时间
     */
    private Long signupEndTime;

    /**
     * 结果公布时间
     */
    private Long resultPublishTime;

    /**
     * 表单类型
     * 1-跳转营销页；2-概率出奖
     */
    @NotNull(message="提交表单后不能为空")
    private Integer afterSign;

    /**
     * 营销页面地址
     */
    private String marketingUrl;

    /**
     * 题目
     */
    private List<SignupQuestionConfigVO> questionList;
}
