package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.join;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayActionRecordDTO;

import java.util.Date;
import java.util.List;

/**
 * 参与玩法API
 * 1.用户请求参与玩法的接口时，自定义代码区域可使用此API
 */
@AdvancedFeignClient
public interface JoinUserRequestApi {

    /**
     * 查询用户今日参与次数
     *
     * @return 用户当前活动今日的参与次数
     * @desc ⚠️ 该处参与不单指dojoin
     */
    Long queryMyTodayCount(Long activityId, String playwayId, Long cid);

    /**
     * 查询用户连续参与的天数
     * 最多不超过100天
     *
     * @return 连续参与天数
     */
    Integer queryMyContinueDays(Long activityId, String playwayId, Long cid);

    /**
     * 查询用户永久参与次数
     *
     * @return 用户当前活动的所有参与次数
     */
    Long queryMyAllCount(Long activityId, String playwayId, Long cid);

    /**
     * 查询用户参与次数
     */
    Long countUserRecord(Long activityId, String playwayId, Long userId, Date start, Date end);

    /**
     * 查询用户最近的参与记录
     *
     * @param limit
     * @return
     */
    List<PlaywayActionRecordDTO> queryMyRecentRecord(Long activityId, String playwayId, Long cid, int limit);

    /**
     * 查询我的参与记录
     *
     * @param start
     * @param end
     * @return
     */
    List<PlaywayActionRecordDTO> queryMyRecords(Long activityId, String playwayId, Long cid, Date start, Date end);

    PlaywayActionRecordDTO find(Long id);

    void updateExtra(Long id, String extra);

    /**
     * 记录一次参与
     * @param activityId 活动id
     * @param playwayId 玩法id
     * @param userId 用户id
     * @param extra 扩展信息
     * @return
     */
    Long doJoin(Long activityId, String playwayId, Long userId, String extra);

    /**
     * 通过参与记录id进行查询
     *
     * @param recordId 参与记录id
     * @return
     */
    PlaywayActionRecordDTO queryById(Long recordId);
}
