package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.base.BasePrizeVo;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayRankingDTO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRankingApi {
    /**
     * 更新排行榜分数
     *
     * @param score    分值
     * @param high2low true:从高到低  false:从低到高
     */
    void updateRankingScore(Long activityId, Long cid, String type, int score, boolean high2low);

    /**
     * 更新排行榜分数自动+1
     * 使用从高到低的排序
     */
    void updateRankingScoreByIncr(Long activityId, Long cid, String type);

    /**
     * 清零我的分数
     *
     * @param type
     */
    void clearRankingScore(Long activityId, Long cid, String type);

    /**
     * 查询我的排名，返回null表明在3000名开外
     *
     * @param type
     * @return
     */
    Integer getUserRank(Long activityId, Long cid, String type);


    /**
     * 查询我的排行榜信息
     *
     * @param type
     * @return
     */
    PlaywayRankingDTO getUserRankInfo(Long activityId, Long cid, String type);

    /**
     * 获取前几名的排行榜信息
     *
     * @param type 排行榜id
     * @param topN 前几名
     *             不允许调用超过1000名的排名，会有性能问题
     * @return ranking 列表
     */
    List<PlaywayRankingDTO> getTopN(Long activityId, String type, int topN);

    /**
     * 得到排名奖
     *
     * @param activityId 活动
     * @param type     类型
     * @return {@link List}<{@link BasePrizeVo}>
     */
    List<BasePrizeVo> getRankingPrize(Long activityId,String type);

}
