/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.activity.service.api.dto.task;

import cn.com.duiba.cloud.biz.tool.utils.EnumUtil;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.BaseDto;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.task.TaskCycleConfig;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.task.TaskDescConfig;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.task.TaskDetail;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.task.TaskRewardConfigDto;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.task.TaskCycleUnitEnum;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TaskDto
extends BaseDto {
    private static final long serialVersionUID = 1L;
    private Long appId;
    private Integer taskType;
    private Integer taskStatus;
    private String taskTitle;
    private Integer taskSwitch;
    private TaskDescConfig descConfig;
    private Date validStart;
    private Date validEnd;
    private TaskCycleConfig taskCycleConfig;
    private TaskDetail taskDetail;
    private Long relationId;
    private List<TaskRewardConfigDto> rewardConfigDtoList = new ArrayList<TaskRewardConfigDto>();
    private String taskCode;

    public static Integer calculateCycleNo(TaskCycleConfig taskCycleConfig, Date taskStartTime, Date recordTime) {
        Integer cycleNo;
        Boolean cycle = taskCycleConfig.getCycle();
        Integer taskCycleUnit = taskCycleConfig.getTaskCycleUnit();
        Integer taskCycleDays = taskCycleConfig.getTaskCycleDays();
        LocalDate startDate = taskStartTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endDate = recordTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (!Objects.equals(cycle, Boolean.TRUE)) {
            cycleNo = 0;
        } else if (taskCycleUnit != null) {
            TaskCycleUnitEnum taskCycleUnitEnum = (TaskCycleUnitEnum)EnumUtil.getByCode(TaskCycleUnitEnum.class, (Object)taskCycleUnit);
            cycleNo = Optional.ofNullable(TaskCycleUnitEnum.calculateNaturalPeriodBetween(taskCycleUnitEnum, startDate, endDate)).map(Long::intValue).orElse(null);
        } else {
            int until = (int)ChronoUnit.DAYS.between(startDate, endDate);
            cycleNo = (until - 1) / taskCycleDays;
        }
        return cycleNo;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setTaskTitle(String taskTitle) {
        this.taskTitle = taskTitle;
    }

    public void setTaskSwitch(Integer taskSwitch) {
        this.taskSwitch = taskSwitch;
    }

    public void setDescConfig(TaskDescConfig descConfig) {
        this.descConfig = descConfig;
    }

    public void setValidStart(Date validStart) {
        this.validStart = validStart;
    }

    public void setValidEnd(Date validEnd) {
        this.validEnd = validEnd;
    }

    public void setTaskCycleConfig(TaskCycleConfig taskCycleConfig) {
        this.taskCycleConfig = taskCycleConfig;
    }

    public void setTaskDetail(TaskDetail taskDetail) {
        this.taskDetail = taskDetail;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public void setRewardConfigDtoList(List<TaskRewardConfigDto> rewardConfigDtoList) {
        this.rewardConfigDtoList = rewardConfigDtoList;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }

    public Long getAppId() {
        return this.appId;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public Integer getTaskStatus() {
        return this.taskStatus;
    }

    public String getTaskTitle() {
        return this.taskTitle;
    }

    public Integer getTaskSwitch() {
        return this.taskSwitch;
    }

    public TaskDescConfig getDescConfig() {
        return this.descConfig;
    }

    public Date getValidStart() {
        return this.validStart;
    }

    public Date getValidEnd() {
        return this.validEnd;
    }

    public TaskCycleConfig getTaskCycleConfig() {
        return this.taskCycleConfig;
    }

    public TaskDetail getTaskDetail() {
        return this.taskDetail;
    }

    public Long getRelationId() {
        return this.relationId;
    }

    public List<TaskRewardConfigDto> getRewardConfigDtoList() {
        return this.rewardConfigDtoList;
    }

    public String getTaskCode() {
        return this.taskCode;
    }
}

