package cn.com.duiba.cloud.biz.tool.utils;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 枚举工具类
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/24 4:27 下午
 * @since 0.0.1
 **/
public class EnumUtil {
    /**
     * 通过枚举值获取枚举对象
     *
     * @param enumClass 枚举类
     * @param dbCode    枚举值
     * @param <E>       枚举对象
     * @param <T>       枚举值数据类型
     * @return 枚举对象
     */
    public static <E extends IEnum<T>, T> E getByCode(Class<E> enumClass, T dbCode) {
        return Stream.of(enumClass.getEnumConstants()).filter(v
                -> Objects.equals(v.getDbCode(), dbCode)).findFirst().orElse(null);
    }
}