/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.aop.validation;

import cn.com.duiba.boot.exception.BizException;
import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ValidationAspect {
    private static final Validator VALIDATOR;

    @Pointcut(value="@within(cn.com.duiba.cloud.biz.tool.aop.validation.Validation) || @annotation(cn.com.duiba.cloud.biz.tool.aop.validation.Validation)")
    public void validate() {
    }

    @Before(value="validate()")
    public void before(JoinPoint point) throws BizException {
        Object[] objects;
        for (Object object : objects = point.getArgs()) {
            Set set = VALIDATOR.validate(object, new Class[0]);
            if (!CollUtil.isNotEmpty((Collection)set)) continue;
            ConstraintViolation oneError = (ConstraintViolation)set.iterator().next();
            String errorMsg = oneError.getMessage();
            throw new BizException(errorMsg);
        }
    }

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        VALIDATOR = factory.getValidator();
    }
}

