/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.constants;

import java.time.Duration;
import java.util.stream.Stream;

public class ExpireConstant {
    public static final String DEFAULT = "DEFAULT";
    public static final String SECOND_10 = "SECOND_10";
    public static final String SECOND_30 = "SECOND_30";
    public static final String MINUTE_1 = "MINUTE_1";
    public static final String MINUTE_5 = "MINUTE_5";
    public static final String MINUTE_15 = "MINUTE_15";
    public static final String MINUTE_30 = "MINUTE_30";
    public static final String HOUR_1 = "HOUR_1";
    public static final String HOUR_3 = "HOUR_3";
    public static final String HOUR_12 = "HOUR_12";
    public static final String DAY_1 = "DAY_1";
    public static final String DAY_3 = "DAY_3";
    public static final String DAY_7 = "DAY_7";
    public static final String DAY_15 = "DAY_15";
    public static final String DAY_30 = "DAY_30";

    public static enum ExpireEnum {
        DEFAULT(Duration.ofHours(1L)),
        SECOND_10(Duration.ofSeconds(10L)),
        SECOND_30(Duration.ofSeconds(30L)),
        MINUTE_1(Duration.ofMinutes(1L)),
        MINUTE_5(Duration.ofMinutes(5L)),
        MINUTE_15(Duration.ofMinutes(15L)),
        MINUTE_30(Duration.ofMinutes(30L)),
        HOUR_1(Duration.ofHours(1L)),
        HOUR_3(Duration.ofHours(3L)),
        HOUR_12(Duration.ofHours(12L)),
        DAY_1(Duration.ofDays(1L)),
        DAY_3(Duration.ofDays(3L)),
        DAY_7(Duration.ofDays(7L)),
        DAY_15(Duration.ofDays(15L)),
        DAY_30(Duration.ofDays(30L));

        private Duration expire;

        public static ExpireEnum findByFirstNameFormat(Stream<String> nameStream) {
            return ExpireEnum.valueOf(nameStream.filter(name -> Stream.of(ExpireEnum.values()).anyMatch(e -> e.name().equalsIgnoreCase((String)name))).findFirst().orElse(DEFAULT.name()));
        }

        public static ExpireEnum findByFirstNameFormat(String ... names) {
            return ExpireEnum.findByFirstNameFormat(Stream.of(names));
        }

        public Duration getExpire() {
            return this.expire;
        }

        private ExpireEnum(Duration expire) {
            this.expire = expire;
        }
    }
}

