package cn.com.duiba.cloud.biz.tool.aop.i18n;

import cn.com.duiba.cloud.biz.tool.AppContext;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * 国际化切面
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/29 3:17 下午
 * @since 0.0.1
 **/
@Slf4j
@Aspect
public class I18nAspect {
    @Pointcut("@within(org.springframework.web.bind.annotation.RestController) || @within(org.springframework.stereotype.Controller)")
    public void i18n() {

    }

    @Around("i18n()")
    public Object doAroundAdvice(ProceedingJoinPoint point) throws Throwable {
        HttpServletRequest request;
        try {
            // 获取request，并set到localThread中
            request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        } catch (Exception e) {
            return point.proceed();
        }
        try {
            AppContext.setRequest(request);
            return point.proceed();
        } finally {
            AppContext.clean();
        }
    }
}