/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AppContext {
    private static ThreadLocal<HttpServletRequest> request = new InheritableThreadLocal<HttpServletRequest>();

    public static void setRequest(HttpServletRequest req) {
        request.set(req);
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes attributes;
        HttpServletRequest req = request.get();
        if (req == null && (attributes = RequestContextHolder.getRequestAttributes()) != null) {
            req = ((ServletRequestAttributes)attributes).getRequest();
        }
        return req;
    }

    public static void clean() {
        request.remove();
    }

    public static Locale getLocal() {
        HttpServletRequest req = AppContext.getRequest();
        if (req == null) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        return req.getLocale();
    }
}

