/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.message;

import cn.com.duiba.cloud.biz.tool.message.Error;
import cn.com.duiba.cloud.biz.tool.message.ErrorMeta;
import cn.hutool.core.collection.CollUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ErrorFactory {
    private static final Logger log = LoggerFactory.getLogger(ErrorFactory.class);
    private static Set<String> noModuleCache = CollUtil.newHashSet((Object[])new String[0]);
    private static MessageSourceAccessor errorMessageSourceAccessor;

    public static void initMessageSource(List<String> isvModules) {
        HashSet baseNamesSet = CollUtil.newHashSet((Object[])new String[0]);
        if (!isvModules.isEmpty()) {
            baseNamesSet.addAll(isvModules);
        }
        Object[] totalBaseNames = baseNamesSet.toArray(new String[0]);
        log.info("\u52a0\u8f7d\u9519\u8bef\u7801\u56fd\u9645\u5316\u8d44\u6e90\uff1a{}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])totalBaseNames));
        ResourceBundleMessageSource bundleMessageSource = new ResourceBundleMessageSource();
        bundleMessageSource.setBasenames((String[])totalBaseNames);
        MessageSourceAccessor messageSourceAccessor = new MessageSourceAccessor((MessageSource)bundleMessageSource);
        ErrorFactory.setErrorMessageSourceAccessor(messageSourceAccessor);
    }

    public static Error<String> getError(ErrorMeta errorMeta, Locale locale, Object ... params) {
        Assert.notNull((Object)locale, (String)"\u672a\u8bbe\u7f6eLocale");
        final String code = errorMeta.getCode();
        String errorMessage = ErrorFactory.getErrorMessage(errorMeta.getIsvModule() + code, locale, params);
        if (StringUtils.isEmpty((Object)errorMessage)) {
            errorMessage = errorMeta.getMsg();
        }
        final String errorMsg = errorMessage;
        return new Error<String>(){

            @Override
            public String getMsg() {
                return errorMsg;
            }

            @Override
            public String getCode() {
                return code;
            }
        };
    }

    public static void setErrorMessageSourceAccessor(MessageSourceAccessor errorMessageSourceAccessor) {
        ErrorFactory.errorMessageSourceAccessor = errorMessageSourceAccessor;
    }

    public static String getErrorMessage(String module, Locale locale, Object ... params) {
        if (noModuleCache.contains(module)) {
            return null;
        }
        try {
            return errorMessageSourceAccessor.getMessage(module, params, locale);
        }
        catch (Exception e) {
            noModuleCache.add(module);
            return null;
        }
    }
}

