package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.SpuAuditStatusEnum;
import cn.com.duiba.cloud.channel.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/4 15:52
 */
@Setter
@Getter
public class SpuAuditAuditParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "审批单Id不能为空")
    private Long spuAuditId;

    /**
     * 50-审核通过 99-审批拒绝
     *
     * @see SpuAuditStatusEnum
     */
    @NotNull(message = "审批状态不能为空")
    private Integer auditStatus;

    /**
     * 审核备注
     * 50个字
     */
    private String auditReason = "";

    // 以下参数前端不用传

    // 是否要更新spu的最近一次审批状态
    private Boolean needUpdateSpuLastAuditStatus = true;

    private Long appId;
    private Long spuId;
}
