package cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/31 4:11 下午
 **/
@Data
public class OrderCouponUseDTO implements Serializable {

    private static final long serialVersionUID = -8688603630236780352L;
    /**
     * skuId
     */
    private Long skuId;

    /**
     * 卡券类型
     */
    private Integer couponType;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期截止时间
     */
    private Date endTime;

    /**
     * 券码相关信息
     */
    private List<CouponCardDTO> couponCardDTOS;

    @Data
    public static class CouponCardDTO implements Serializable {

        private static final long serialVersionUID = 5679339579597597894L;
        /**
         * 券码
         */
        private String cardNo;

        /**
         * 密码
         */
        private String cardPassword;
    }
}