package cn.com.duiba.cloud.duiba.goods.center.api.param.attribute;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.AttributeTypeEnum;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ListAttributeByCategoryIdParam implements Serializable {

    private static final long serialVersionUID = -3985091231281312064L;

    @NotNull(message = "类目ID不能为空")
    private Long categoryId;

    private Long attributeId;

    /**
     * 属性类型 {@link AttributeTypeEnum}
     */
    private Integer attrType;

    private String attributeName;

    private Integer attrState;
}
