package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

/**
 * @Description 订单扩展信息类型说明枚举类
 * @Author dangcang
 * @Date 2021/11/14 11:00 上午
 **/
@Getter
public enum OrderExtraBizTypeEnum {

    TENANT_REMARK(1,"租户-订单备注"),
    REMIND(2,"订单提醒"),
    THIRD_ORDER_CODE(3, "第三方订单号"),
    LIFE_CYCLE(4, "生命周期"),
    TENANT_CANCEL_REASON(5, "租户取消订单原因"),
    PURCHASE_AFTER_SALE_NUMBER(6, "销售订单售后单号关联的采购订单售后单号 双向记录"),
    GOODS_SELLER_APP_ID(7, "商品销售方AppId"),
    OLD_MNG_SUB_ORDER_CODE(8, "老MNG定制需求 双方子订单号需要关联上"),
    THIRD_ORDER_ERROR_MESSAGE(9,"第三方下单失败原因"),
    PURCHASE_SALE_ORDER_SORT(10, "销售订单关联的采购订单子单号 双向记录")

    ;


    private Integer type;

    private String desc;

    OrderExtraBizTypeEnum(Integer type, String desc) {
        this.desc = desc;
        this.type = type;
    }
}