package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 优惠信息
 * @Author dangcang
 * @Date 2021/11/15 11:46 上午
 **/
@Data
public class DiscountDTO implements Serializable {

    private static final long serialVersionUID = -6637085757339376276L;
    /**
     * 订单code
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 优惠源
     * @see cn.com.duiba.cloud.order.center.api.enums.DiscountSourceEnum
     */
    private Integer discountSource;

    /**
     * 优惠类型
     * @see cn.com.duiba.cloud.order.center.api.enums.PayTypeEnum
     */
    private Integer discountType;

    /**
     * 优惠数量，法币单位：分，积分单位：个
     */
    private Long discountNum;
}