package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 订单扩展信息
 * @Author dangcang
 * @Date 2021/11/14 11:34 上午
 **/
@Data
public class OrderExtraDTO implements Serializable {

    private static final long serialVersionUID = -3699953657970832865L;
    /**
     * 扩展信息id;
     */
    private Long orderExtraId;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 扩展信息
     */
    private String message;

    /**
     * 扩展信息类型
     * @see cn.com.duiba.cloud.order.center.api.enums.OrderTypeEnum
     */
    private Integer bizType;

    /**
     * 创建时间 毫秒级时间戳
     */
    private Long gmtCreateTime;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 更新时间 毫秒级时间戳
     */
    private Long gmtModified;

    /**
     * 更新人
     */
    private Long updateBy;

    /**
     * 截止时间 毫秒级时间戳
     */
    private Long endTime;
}