package cn.com.duiba.cloud.order.center.api.model.param.order;

import cn.com.duiba.cloud.order.center.api.enums.ExportTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/8 1:04 下午
 **/
@Data
public class ExportOrderParam implements Serializable {

    private static final long serialVersionUID = -5726590476847141885L;

    /**
     * 当前账户操作人id
     */
    private Long innerUserId;

    /**
     * 企业id
     */
    private Long tenantId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 导出类型
     * 传了相应的枚举值后只需要往相应的param塞值
     * @see ExportTypeEnum
     */
    private Integer exportType;

    /**
     * 导出主订单分页查询参数
     */
    private OrderQueryParam mainQueryParam;

    /**
     * 导出子订单分页查询参数
     */
    private SubOrderQueryParam subOrderQueryParam;
}