package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

;

/**
 * @Description 申请售后
 * @Author dangcang
 * @Date 2021/11/11 10:00 上午
 **/
@Data
public class OpenCreateAfterSaleParam implements Serializable {

    private static final long serialVersionUID = -386661956441466429L;
    /**
     * 订单编号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderCode;

    /**
     * 子订单序号
     */
    @NotNull(message = "子订单序号不能为空")
    private Long orderSort;

    /**
     * 售后类型
     * @see cn.com.duiba.cloud.order.center.api.enums.AfterSaleTypeEnum
     */
    @NotNull(message = "售后类型不能为空")
    private Integer afterSaleType;

    /**
     * 售后方式
     * @see cn.com.duiba.cloud.order.center.api.enums.AfterSaleWayEnum
     */
    @NotNull(message = "售后方式不能为空")
    private Integer afterSaleWay;

    /**
     * 售后原因
     */
    @NotBlank(message = "售后原因不能为空")
    private String afterSaleReason;

    /**
     * 售后凭证 英文逗号,分割 最大512
     */
    @Size(max = 512)
    private String imgSrcList;

    /**
     * 应用上下文参数
     */
    @NotNull(message = "应用上下文参数不能为空")
    private ApiContext apiContext;
}