package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 开放平台订单回调接口参数
 * @Author dangcang
 * @Date 2022/3/7 12:07 下午
 **/
@Data
public class OpenOrderCallbackParam implements Serializable {

    private static final long serialVersionUID = -2246372903625868718L;
    /**
     * 第三方订单编号
     */
    @NotBlank(message = "第三订单号不能为空")
    private String thirdOrderCode;

    /**
     * 第三方订单状态
     * @see cn.com.duiba.cloud.order.center.api.enums.OrderStatusEnum
     */
    @NotNull(message="第三方订单状态不能为空")
    private Integer thirdStatus;

    /**
     * 兑吧订单号
     */
    @NotBlank(message = "兑吧订单号不能为空")
    private String orderCode;
}