package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.dto.logistics.DispatchBillDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.logistics.ExpressDetailDTO;
import cn.com.duiba.cloud.order.center.api.model.param.logistics.LogisticsMsgParam;

import java.util.List;
import java.util.Map;

/**
 * @Description 物流、发货读相关
 * @Author dangcang
 * @Date 2021/11/14 10:00 上午
 **/
@AdvancedFeignClient
public interface RemoteLogisticsReadService {

    /**
     * 物流轨迹查询-单条
     * @param param
     * @param dispatchBillBizType
     * @return
     * @throws BizException
     */
    List<ExpressDetailDTO> logisticsInfoQuery(LogisticsMsgParam param, Integer dispatchBillBizType) throws BizException;

    /**
     * 获取发货单详情
     * key = orderCode
     * value = 订单下的发货单信息
     * @param params
     * @param dispatchBillBizType
     * @return
     * @throws BizException
     */
    Map<String, List<DispatchBillDTO>> batchGetDispatchBill(List<LogisticsMsgParam> params, Integer dispatchBillBizType) throws BizException;

    /**
     * 获取子订单快递详情
     * @param orderCode
     * @param orderSort
     * @param dispatchBillBizType
     * @return
     * @throws BizException
     */
    DispatchBillDTO getSubDispatchBill(String orderCode, Long orderSort, Integer dispatchBillBizType) throws BizException;
}