/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.order.center.api.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang.StringUtils;

public class MoneyUtil {
    private static final String HUNDREDS = "100";

    private MoneyUtil() {
    }

    public static Long convertToCent(String money) {
        if (StringUtils.isBlank((String)money)) {
            return 0L;
        }
        return new BigDecimal(HUNDREDS).multiply(new BigDecimal(money)).longValue();
    }

    public static String formatMoneyToKeep2Point(Long money) {
        if (money == null) {
            return "";
        }
        return new BigDecimal(money).divide(new BigDecimal(HUNDREDS), 2, RoundingMode.DOWN).toString();
    }
}

