package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.dto.order.OrderExtraDTO;
import cn.com.duiba.cloud.order.center.api.model.param.extra.OrderExtraQueryParam;

import java.util.List;

/**
 * @Description 订单扩展信息相关读操作接口
 * @Author dangcang
 * @Date 2021/11/10 1:37 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderExtraReadService {

    /**
     * 通过订单号列表批量获取
     * @param orderCodeList
     * @param bizType
     * @see cn.com.duiba.cloud.order.center.api.enums.OrderExtraBizTypeEnum
     * @return
     * @throws BizException
     */
    List<OrderExtraDTO> batchOrderExtraByOrderCodeList(List<String> orderCodeList, Integer bizType) throws BizException;

    /**
     * 订单扩展信息查询
     * @param param
     * @return
     * @throws BizException
     */
    List<OrderExtraDTO> getOrderExtraList(OrderExtraQueryParam param) throws BizException;
}