package cn.com.duiba.cloud.stock.service.api.enums.stock;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 库存流水业务类型枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/23 5:10 下午
 **/
@Getter
@AllArgsConstructor
public enum StockFlowTypeEnum implements IEnum<Integer> {
    /**
     * 销售订单<br>
     * <ul>
     *     <li>普退订单消耗库存刘辉</li>
     * </ul>
     */
    ORDER(1, "销售订单", "order"),

    /**
     * 库存初始化<br>
     * <ul>
     *     <li>创建库存流水</li>
     * </ul>
     */
    INIT(2, "库存初始化", "init"),

    /**
     * 修改库存<br>
     * <ul>
     *     <li>修改库存流水</li>
     * </ul>
     */
    UPDATE(3, "修改库存", "update"),

    /**
     * 主库存直接预占<br>
     * <ul>
     *     <li>通过自有库存直接给活动预占库存流水</li>
     *     <li>通过自由库存直接修改活动预占库存流水</li>
     *     <li>返还活动库存，独占库存不存在，返还主库存流水</li>
     *     <li>兑吧删除商品，活动预占库存直接返还主库存流水</li>
     * </ul>
     */
    DISPATCH(4, "主库存直接预占", "dispatch"),

    /**
     * 活动订单<br>
     * <ul>
     *     <li>活动下单消耗库存流水</li>
     * </ul>
     */
    ACTIVITY(5, "活动订单", "activity"),

    /**
     * 返库<br>
     * <ul>
     *    <li>活动预占存在时，订单失败返还预占库存流水</li>
     *    <li>活动预占不存在且独占库存也不存在时，订单失败返还主库存流水</li>
     * </ul>
     */
    ROLLBACK(6, "返库", "rollback"),

    /**
     * 独占库存<br>
     * <ul>
     *     <li>兑吧给开发者独占库存流水</li>
     *     <li>兑吧修改开发者独占库存流水</li>
     *     <li>兑吧删除开发者独占库存返还主库存流水</li>
     * </ul>
     */
    MONOPOLIZE(7, "独占库存", "monopolize"),

    /**
     * 独占库存预占<br>
     * <ul>
     *     <li>开发者通过独占库存给活动添加预占库存流水</li>
     *     <li>开发者通过独占库存修改活动预占库存流水</li>
     *     <li>开发者存在独占库存时，返还活动库存到独占库存流水</li>
     * </ul>
     */
    MONOPOLIZE_DISPATCH(8, "独占库存预占", "monopolizeDispatch"),

    /**
     * 返库到独占库存<br>
     * <ul>
     *     <li>活动预占不存在且存在独占库存时，订单失败返还独占库存流水</li>
     * </ul>
     */
    ROLLBACK_TO_MONOPOLIZE(9, "返库到独占库存", "rollbackToMonopolize"),

    /**
     * 批次过期清算<br>
     * <ul>
     *     <li>批次过期清除批次库存流水</li>
     * </ul>
     */
    LOT_EXPIRED_CLEAR(10, "批次过期清算", "lotExpiredClear"),
    ;

    /**
     * 业务类型id
     */
    private Integer dbCode;

    /**
     * 业务类型描述
     */
    private String desc;

    /**
     * 业务场景标识
     */
    private String scene;
}