package cn.com.duiba.cloud.stock.service.api.exception;

import cn.com.duiba.cloud.biz.tool.message.ErrorMeta;

/**
 * 库存错误
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/29 11:33 上午
 * @since 0.0.1
 **/
public interface StockError {
    String STOCK_ISV = "stock.error_";

    /**
     * {0}({1})获取预占库存为空
     */
    ErrorMeta GET_OCCUPY_STOCK_IS_NULL = new ErrorMeta(STOCK_ISV, "130301", "获取预占库存为空");
    ErrorMeta CONSUME_OCCUPY_STOCK_EXCEPTION = new ErrorMeta(STOCK_ISV, "130302", "消耗预占库存异常");
    /**
     * {0}({1})获取批次库存为空
     */
    ErrorMeta GET_LOT_STOCK_IS_NULL = new ErrorMeta(STOCK_ISV, "130303", "获取批次库存为空");
    /**
     * {0}({1})获取库存为空
     */
    ErrorMeta GET_STOCK_IS_NULL = new ErrorMeta(STOCK_ISV, "130304", "获取库存为空");
    ErrorMeta CONSUME_ORDER_STOCK_EXCEPTION = new ErrorMeta(STOCK_ISV, "130305", "消耗订单库存异常");
    /**
     * {0}参数有误
     */
    ErrorMeta PARAM_IS_ERROR = new ErrorMeta(STOCK_ISV, "130306", "参数有误");
    ErrorMeta STOCK_NUMBER_NOT_MATCH = new ErrorMeta(STOCK_ISV, "130307", "总库存和批次库存不匹配");
    /**
     * {0}({1})获取库存流水为空
     */
    ErrorMeta GET_STOCK_FLOW_IS_NULL = new ErrorMeta(STOCK_ISV, "130308", "获取库存流水为空");
    ErrorMeta LOT_STOCK_NUMBER_IS_NULL_OR_LT_ZERO = new ErrorMeta(STOCK_ISV, "130309", "批次库存数量为空或小于0");
    /**
     * {0}({1})没有预占库存且未开启共享库存
     */
    ErrorMeta OCCUPY_IS_NULL_AND_SHARE_INVALID = new ErrorMeta(STOCK_ISV, "130310", "没有预占库存且未开启共享库存");
    /**
     * {0}({1})存在独占库存，无法扣减，请检查后操作
     */
    ErrorMeta ABSOLUTE_UPDATE_STOCK_NUMBER_LESS_OCCUPY_NUMBER = new ErrorMeta(STOCK_ISV, "130311", "商品存在独占库存，无法扣减，请检查后操作");
}