package cn.com.duiba.cloud.stock.service.api.param.lot;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 批量获取库存批次信息请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-04-24 20:18
 * @since 0.0.6
 **/
@Data
@Accessors(chain = true)
public class RemoteBatchGetStockLotInfoParam implements Serializable {
    private static final long serialVersionUID = -7112630589194251590L;

    /**
     * skuId列表
     */
    @NotNull(message = "skuId列表不能为空")
    @Size(min = 1, max = 100, message = "skuId列表大小必须在1-100之间")
    private List<Long> skuIdList;
}
