package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 根据活动id，批量获取sku的活动预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-04-10 16:52
 * @since 0.0.6
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteGetActivityStockByActivityIdParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = -8006702947523385660L;

    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;

    /**
     * skuId列表
     */
    @NotNull(message = "skuId列表不能为空")
    @Size(min = 1, max = 100, message = "skuId列表大小必须在1-100之间")
    private List<Long> skuIdList;
}
