package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowStatusEnum;
import cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowTypeEnum;
import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 修改库存状态请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/29 4:43 下午
 **/
@Data
@Accessors(chain = true)
public class UpdateStockStatusParam implements Serializable {
    private static final long serialVersionUID = -8594099608017993959L;

    @Valid
    @NotNull(message = "修改库存状态子参数不能为空")
    @Size(min = 1, max = 20, message = "修改库存状态子参数大小必须在1-20")
    private List<UpdateStockStatusSubParam> updateStockStatusSubParamList;

    @Data
    @Accessors(chain = true)
    @EqualsAndHashCode(callSuper = true)
    public static class UpdateStockStatusSubParam extends BaseAppParam implements Serializable {
        private static final long serialVersionUID = 4351340710339755324L;

        /**
         * 业务单号
         */
        @NotBlank(message = "业务单号不能为空")
        private String bizNo;

        /**
         * 业务类型 {@link StockFlowTypeEnum}
         */
        @NotBlank(message = "业务类型不能为空")
        @Pattern(regexp = "^[15]$", message = "业务类型值只能为1和5")
        private String bizType;

        /**
         * 变更的库存状态 {@link StockFlowStatusEnum}
         */
        @NotBlank(message = "库存流水状态不能为空")
        @Pattern(regexp = "^[234]$", message = "库存流水状态必须在2、3、4之间")
        private String stockStatus;

        /**
         * 返还库存类型<br>
         * 老兑吧定制字段
         */
        @Deprecated
        @Range(min = 1, max = 2, message = "返还库存类型有误")
        private Integer rollBackType;
    }

    @SuppressWarnings("DeprecatedIsStillUsed")
    @Getter
    @AllArgsConstructor
    @Deprecated
    public enum RollbackTypeEnum {
        /**
         * 返还到预占库存
         */
        OCCUPY(1, "预占库存"),
        /**
         * 返还到主库存
         */
        MAIN(2, "主库存"),
        ;

        private Integer code;

        private String desc;
    }
}