package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.lot.StockLotDTO;
import cn.com.duiba.cloud.stock.service.api.param.lot.RemoteBatchGetStockLotInfoParam;

import java.util.List;

/**
 * 库存批次remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-04-24 20:13
 * @since 0.0.6
 **/
@AdvancedFeignClient
public interface RemoteStockLotService {
    /**
     * 根据skuId列表批量获取库存批次信息
     *
     * @param remoteBatchGetStockLotInfoParam 批量获取库存批次信息请求参数
     * @return 库存批次信息
     */
    List<StockLotDTO> batchGetStockLotInfo(RemoteBatchGetStockLotInfoParam remoteBatchGetStockLotInfoParam);
}
