package cn.com.duiba.cloud.stock.service.api.enums.stock;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * redisKey枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/20 10:34 下午
 * @since 0.0.1
 **/
@AllArgsConstructor
@Getter
public enum StockRedisKeyEnum {
    /**
     * 预占校验锁
     */
    K01("活动预占校验锁"),
    K02("独占预占校验锁"),
    ;

    /**
     * key前缀
     */
    private static final String PREFIX = "duiba-stock-service";

    private String desc;

    /**
     * 拼接key
     *
     * @param str 拼接字符串
     * @return 拼接后的key
     */
    public String join(Object... str) {
        return toString().concat(StringUtils.join(str, "_"));
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return PREFIX + "_" + super.toString() + "_";
    }
}