package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 返还活动预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/17 5:40 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RollbackOccupyStockParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = -5909421412751718877L;

    /**
     * generalId列表
     */
    @NotNull(message = "generalId列表不能为空")
    @Size(min = 1, message = "generalId列表大小最小必须为1")
    private List<Long> generalIdList;
}