package cn.com.duiba.cloud.stock.service.api.dto.occupy;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 活动库存DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-04-11 14:29
 * @since 0.0.6
 **/
@Data
@Accessors(chain = true)
public class ActivityStockInfoDTO implements Serializable {
    private static final long serialVersionUID = -6755189751782524162L;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 活动预占库存
     */
    private Long stockNumber;

    /**
     * 预占类型
     *
     * @see StockOccupyEnum
     */
    private Integer generalType;
}
