package cn.com.duiba.cloud.stock.service.api.param.occupy;

import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 批量仅获取预占可用库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-07-11 15:19
 * @since 0.1.0
 **/
@Data
@Accessors(chain = true)
public class RemoteBatchFindOccupyOnlyValueParam implements Serializable {
    private static final long serialVersionUID = -7237898010439783694L;

    /**
     * 预占范id列表
     */
    @NotNull(message = "generalId列表不能为空")
    @Size(min = 1, max = 100, message = "generalId列表大小必须在1-100之间")
    private List<Long> generalIds;

    /**
     * 预占类型
     */
    @NotNull(message = "预占类型不能为空")
    @Range(min = 1, max = 4, message = "预占类型错误")
    private Integer generalType;
}
