package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 编辑独占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-03-28 11:37
 * @since 0.0.6
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteEditMonopolizeStockParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = -6394752693803573540L;

    /**
     * 新增独占库存参数
     */
    @Valid
    @Size(min = 1, max = 20, message = "新增独占库存参数大小必须在1-20之间")
    private List<AddMonopolizeStockParam> addMonopolizeStockParamList;

    /**
     * 变更预占库存参数
     */
    @Valid
    @Size(min = 1, max = 20, message = "变更独占库存参数大小必须在1-20之间")
    private List<ChangeMonopolizeStockParam> changeMonopolizeStockParamList;

    /**
     * 清除独占库存参数
     */
    @Size(min = 1, max = 20, message = "清除独占库存参数大小必须在1-20之间")
    private List<CleanMonopolizeStockParam> cleanMonopolizeStockParamList;

    @Data
    @Accessors(chain = true)
    public static class AddMonopolizeStockParam implements Serializable {
        private static final long serialVersionUID = -4856455073796406531L;

        /**
         * 独占预占id
         */
        @NotNull(message = "独占预占id不能为空")
        private Long generalId;

        /**
         * 独占的开发者应用id
         */
        @NotNull(message = "独占的开发者应用id不能为空")
        private Long monopolizeAppId;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 调度值<br>
         */
        @NotNull(message = "独占库存数量不能为空")
        @Min(value = 0, message = "独占库存数量不能小于0")
        private Long dispatchValue;
    }

    @Data
    @Accessors(chain = true)
    public static class ChangeMonopolizeStockParam implements Serializable {
        private static final long serialVersionUID = 616649119169139487L;

        /**
         * 独占的开发者应用id
         */
        @NotNull(message = "独占的开发者应用id不能为空")
        private Long monopolizeAppId;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 更新值
         */
        @NotNull(message = "变更值不能为空")
        private Long changeValue;
    }

    @Data
    @Accessors(chain = true)
    public static class CleanMonopolizeStockParam implements Serializable {
        private static final long serialVersionUID = -4141108831317329390L;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 独占的开发者应用id
         */
        @NotNull(message = "独占的开发者应用id不能为空")
        private Long monopolizeAppId;
    }
}
