package cn.com.duiba.cloud.stock.service.api.param.occupy;

import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 仅获取预占可用库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-07-11 15:02
 * @since 0.1.0
 **/
@Data
@Accessors(chain = true)
public class RemoteFindOccupyOnlyValueParam implements Serializable {
    private static final long serialVersionUID = 1660737709998378867L;

    /**
     * 预占范id
     */
    @NotNull(message = "generalId不能为空")
    private Long generalId;

    /**
     * 预占类型
     */
    @NotNull(message = "预占类型不能为空")
    @Range(min = 1, max = 4, message = "预占类型错误")
    private Integer generalType;
}
