package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 通过sku获取预占列表库存信息请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/12/8 2:48 下午
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class StockOccupyGeneralInfoParam extends PageRequest implements Serializable {
    private static final long serialVersionUID = 7899733971235385765L;

    /**
     * 应用id
     */
    @NotNull(message = "应用id不能为空")
    private Long appId;

    /**
     * skuId
     */
    @NotNull(message = "skuId不能为空")
    private Long skuId;

    /**
     * 预占类型
     *
     * @see StockOccupyEnum
     */
    @NotNull(message = "预占类型不能为空")
    @Range(min = 1, max = 4, message = "预占类型错误")
    private Integer generalType;
}