package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 秒杀请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-07-13 11:16
 * @since 0.1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteSecKillParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = -6263647720466775742L;

    /**
     * 预占场景id<br>
     * 创建秒杀预占库存时的generalId
     */
    @NotNull(message = "预占场景id不能为空")
    private Long generalId;

    /**
     * 消耗值
     */
    @NotNull(message = "消耗值不能为空")
    @Max(value = -1, message = "消耗值最大为-1")
    private Long delta;

    /**
     * 业务单号
     */
    @NotBlank(message = "业务单号不能为空")
    private String bizNo;
}
